/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy;

import java.lang.invoke.MethodHandles;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.RailsForeignKeyConstraint;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.util.Inflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DbAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static List<RailsForeignKeyConstraint> getRailsConstraints(Map<String, Table> tables) {
        ArrayList<RailsForeignKeyConstraint> railsConstraints = new ArrayList<RailsForeignKeyConstraint>(tables.size());
        for (Table table : tables.values()) {
            for (TableColumn column : table.getColumns()) {
                TableColumn primaryColumn;
                String singular;
                String primaryTableName;
                Table primaryTable;
                String columnName = column.getName().toLowerCase();
                if (column.isForeignKey() || !column.allowsImpliedParents() || !columnName.endsWith("_id") || (primaryTable = tables.get(primaryTableName = Inflection.pluralize((String)(singular = columnName.substring(0, columnName.length() - "_id".length()))))) == null || (primaryColumn = primaryTable.getColumn("ID")) == null) continue;
                railsConstraints.add(new RailsForeignKeyConstraint(primaryColumn, column));
            }
        }
        return railsConstraints;
    }

    public static List<ForeignKeyConstraint> getForeignKeyConstraints(Collection<Table> tables) {
        ArrayList<ForeignKeyConstraint> constraints = new ArrayList<ForeignKeyConstraint>();
        for (Table table : tables) {
            constraints.addAll(table.getForeignKeys());
        }
        return constraints;
    }

    public static List<Table> getTablesWithoutIndexes(Collection<Table> tables) {
        ArrayList<Table> withoutIndexes = new ArrayList<Table>();
        for (Table table : tables) {
            if (!table.getIndexes().isEmpty() || table.isView() || table.isLogical()) continue;
            withoutIndexes.add(table);
        }
        return DbAnalyzer.sortTablesByName(withoutIndexes);
    }

    public static List<Table> getTablesWithIncrementingColumnNames(Collection<Table> tables) {
        ArrayList<Table> denormalizedTables = new ArrayList<Table>();
        block0: for (Table table : tables) {
            HashMap<String, Long> columnPrefixes = new HashMap<String, Long>();
            for (TableColumn column : table.getColumns()) {
                String columnName = column.getName();
                String numbers = null;
                for (int i = columnName.length() - 1; i > 0 && Character.isDigit(columnName.charAt(i)); --i) {
                    numbers = String.valueOf(columnName.charAt(i)) + (numbers == null ? "" : numbers);
                }
                if (numbers == null) {
                    numbers = "1";
                    columnName = columnName + numbers;
                }
                String prefix = columnName.substring(0, columnName.length() - numbers.length());
                long numeric = Long.parseLong(numbers);
                Long existing = (Long)columnPrefixes.get(prefix);
                if (existing != null && Math.abs(existing - numeric) == 1L) {
                    denormalizedTables.add(table);
                    continue block0;
                }
                columnPrefixes.put(prefix, numeric);
            }
        }
        return DbAnalyzer.sortTablesByName(denormalizedTables);
    }

    public static List<Table> getTablesWithOneColumn(Collection<Table> tables) {
        ArrayList<Table> singleColumnTables = new ArrayList<Table>();
        for (Table table : tables) {
            if (table.getColumns().size() != 1) continue;
            singleColumnTables.add(table);
        }
        return DbAnalyzer.sortTablesByName(singleColumnTables);
    }

    public static List<Table> sortTablesByName(List<Table> tables) {
        tables.sort(Table::compareTo);
        return tables;
    }

    public static List<TableColumn> sortColumnsByTable(List<TableColumn> columns) {
        columns.sort((column1, column2) -> {
            int rc = column1.getTable().compareTo(column2.getTable());
            if (rc == 0) {
                rc = column1.getName().compareToIgnoreCase(column2.getName());
            }
            return rc;
        });
        return columns;
    }

    public static List<TableColumn> getDefaultNullStringColumns(Collection<Table> tables) {
        ArrayList<TableColumn> defaultNullStringColumns = new ArrayList<TableColumn>();
        for (Table table : tables) {
            for (TableColumn column : table.getColumns()) {
                String defaultString;
                Object defaultValue = column.getDefaultValue();
                if (!(defaultValue instanceof String) || !"'null'".equalsIgnoreCase((defaultString = defaultValue.toString()).trim())) continue;
                defaultNullStringColumns.add(column);
            }
        }
        return DbAnalyzer.sortColumnsByTable(defaultNullStringColumns);
    }

    public static List<String> getCatalogs(DatabaseMetaData meta) throws SQLException {
        ArrayList<String> catalogs = new ArrayList<String>();
        ResultSet rs = meta.getCatalogs();
        while (rs.next()) {
            catalogs.add(rs.getString("TABLE_CAT"));
        }
        rs.close();
        return catalogs;
    }

    public static List<String> getSchemas(DatabaseMetaData meta) throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        ResultSet rs = meta.getSchemas();
        while (rs.next()) {
            schemas.add(rs.getString("TABLE_SCHEM"));
        }
        rs.close();
        return schemas;
    }

    public static List<String> getPopulatedSchemas(DatabaseMetaData meta) throws SQLException {
        return DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta, (String)".*", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPopulatedSchemas(DatabaseMetaData meta, String schemaSpec, boolean isCatalog) throws SQLException {
        TreeSet<String> schemas = new TreeSet<String>();
        Pattern schemaRegex = Pattern.compile(schemaSpec);
        for (String schema : isCatalog ? DbAnalyzer.getCatalogs((DatabaseMetaData)meta) : DbAnalyzer.getSchemas((DatabaseMetaData)meta)) {
            if (schemaRegex.matcher(schema).matches()) {
                ResultSet rs = null;
                try {
                    rs = meta.getTables(null, schema, "%", null);
                    if (rs.next()) {
                        LOGGER.debug("Including schema {}: matches + \"{}\" and contains tables", (Object)schema, (Object)schemaRegex);
                        schemas.add(schema);
                        continue;
                    }
                    LOGGER.debug("Excluding schema {}: matches \"{}\" but contains no tables", (Object)schema, (Object)schemaRegex);
                    continue;
                }
                catch (SQLException sqlex) {
                    LOGGER.debug("SQLException caught during populateSchemas", (Throwable)sqlex);
                    continue;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    continue;
                }
            }
            LOGGER.debug("Excluding schema {}: doesn't match '{}'", (Object)schema, (Object)schemaRegex);
        }
        return new ArrayList<String>(schemas);
    }
}

