/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms;

import java.lang.invoke.MethodHandles;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;
import org.schemaspy.model.InvalidConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private DatabaseMetaData databaseMetaData;

    public CatalogResolver(DatabaseMetaData databaseMetaData) {
        this.databaseMetaData = databaseMetaData;
    }

    public String resolveCatalog(String currentCatalog) {
        if (Objects.isNull(currentCatalog)) {
            String catalog = null;
            try {
                catalog = this.databaseMetaData.getConnection().getCatalog();
                LOGGER.debug("Catalog not provided, queried jdbc driver and got '{}'", (Object)catalog);
            }
            catch (SQLException sqle) {
                LOGGER.error("Catalog (-cat) not provided, queried jdbc driver for catalog and failed", (Throwable)sqle);
            }
            if (Objects.isNull(catalog)) {
                throw new InvalidConfigurationException("Catalog (-cat) was not provided and unable to deduce catalog, wildcard catalog can be used -cat %");
            }
            return catalog;
        }
        return currentCatalog;
    }
}

