/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.classpath;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import org.schemaspy.input.dbms.classpath.Classpath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadAdditionalJarsForDriver
implements Classpath {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String driverPath;

    public LoadAdditionalJarsForDriver(String driverPath) {
        this.driverPath = driverPath;
    }

    public Set<URI> paths() {
        HashSet<URI> result = new HashSet<URI>();
        File driverFolder = new File(Paths.get(this.driverPath, new String[0]).getParent().toString());
        if (driverFolder.exists()) {
            File[] files = driverFolder.listFiles((dir, name) -> name.toLowerCase().matches(".*\\.?ar$"));
            LOGGER.info("Additional files will be loaded for JDBC Driver");
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    result.add(file.toURI());
                    LOGGER.info("Added: {}", (Object)file.toURI());
                }
            }
        }
        return result;
    }
}

