/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.xml;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.schemaspy.input.dbms.xml.ForeignKeyMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableColumnMeta {
    private final String name;
    private final String type;
    private final boolean isPrimary;
    private final String id;
    private final int size;
    private final int digits;
    private final boolean isNullable;
    private final String comments;
    private final String defaultValue;
    private final boolean isAutoUpdated;
    private final List<ForeignKeyMeta> foreignKeys = new ArrayList();
    private final boolean isExcluded;
    private final boolean isAllExcluded;
    private final boolean isImpliedParentsDisabled;
    private final boolean isImpliedChildrenDisabled;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TableColumnMeta(Node colNode) {
        String tmp;
        NamedNodeMap attribs = colNode.getAttributes();
        this.name = attribs.getNamedItem("name").getNodeValue();
        Node node = attribs.getNamedItem("comments");
        if (node == null && Objects.nonNull(node = attribs.getNamedItem("remarks"))) {
            LOGGER.warn("<remarks> has been deprecated");
        }
        this.comments = node != null ? ((tmp = node.getNodeValue().trim()).length() == 0 ? null : tmp) : null;
        node = attribs.getNamedItem("type");
        this.type = node == null ? "Unknown" : node.getNodeValue();
        node = attribs.getNamedItem("id");
        this.id = node == null ? null : node.getNodeValue();
        node = attribs.getNamedItem("size");
        this.size = node == null ? 0 : Integer.parseInt(node.getNodeValue());
        node = attribs.getNamedItem("digits");
        this.digits = node == null ? 0 : Integer.parseInt(node.getNodeValue());
        node = attribs.getNamedItem("nullable");
        this.isNullable = node != null && this.evalBoolean(node.getNodeValue());
        node = attribs.getNamedItem("autoUpdated");
        this.isAutoUpdated = node != null && this.evalBoolean(node.getNodeValue());
        node = attribs.getNamedItem("primaryKey");
        this.isPrimary = node != null && this.evalBoolean(node.getNodeValue());
        node = attribs.getNamedItem("defaultValue");
        this.defaultValue = node == null ? null : node.getNodeValue();
        node = attribs.getNamedItem("disableImpliedKeys");
        if (node != null) {
            switch (tmp = node.getNodeValue().trim().toLowerCase()) {
                case "to": {
                    this.isImpliedChildrenDisabled = true;
                    this.isImpliedParentsDisabled = false;
                    break;
                }
                case "from": {
                    this.isImpliedParentsDisabled = true;
                    this.isImpliedChildrenDisabled = false;
                    break;
                }
                case "all": {
                    this.isImpliedParentsDisabled = true;
                    this.isImpliedChildrenDisabled = true;
                    break;
                }
                default: {
                    this.isImpliedParentsDisabled = false;
                    this.isImpliedChildrenDisabled = false;
                    break;
                }
            }
        } else {
            this.isImpliedParentsDisabled = false;
            this.isImpliedChildrenDisabled = false;
        }
        if ((node = attribs.getNamedItem("disableDiagramAssociations")) != null) {
            switch (tmp = node.getNodeValue().trim().toLowerCase()) {
                case "all": {
                    this.isAllExcluded = true;
                    this.isExcluded = true;
                    break;
                }
                case "exceptdirect": {
                    this.isAllExcluded = false;
                    this.isExcluded = true;
                    break;
                }
                default: {
                    this.isAllExcluded = false;
                    this.isExcluded = false;
                    break;
                }
            }
        } else {
            this.isAllExcluded = false;
            this.isExcluded = false;
        }
        LOGGER.debug("Found XML column metadata for {} isPrimaryKey: {} comments: {}", new Object[]{this.name, this.isPrimary, this.comments});
        NodeList fkNodes = ((Element)((Object)colNode.getChildNodes())).getElementsByTagName("foreignKey");
        for (int i = 0; i < fkNodes.getLength(); ++i) {
            Node fkNode = fkNodes.item(i);
            this.foreignKeys.add(new ForeignKeyMeta(fkNode));
        }
    }

    private boolean evalBoolean(String exp) {
        if (exp == null) {
            return false;
        }
        String returnExp = exp.trim().toLowerCase();
        return "true".equals(returnExp) || "yes".equals(returnExp) || "1".equals(returnExp);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public int getDigits() {
        return this.digits;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isAutoUpdated() {
        return this.isAutoUpdated;
    }

    public String getComments() {
        return this.comments;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public List<ForeignKeyMeta> getForeignKeys() {
        return this.foreignKeys;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public boolean isAllExcluded() {
        return this.isAllExcluded;
    }

    public boolean isImpliedParentsDisabled() {
        return this.isImpliedParentsDisabled;
    }

    public boolean isImpliedChildrenDisabled() {
        return this.isImpliedChildrenDisabled;
    }
}

