/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.diagram.vizjs;

import java.io.File;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.schemaspy.output.diagram.RenderException;
import org.schemaspy.output.diagram.Renderer;
import org.schemaspy.util.DefaultBufferedWriter;

public class VizJSDot
implements Renderer {
    private static final String ICON_SIZE = " , width: \"261px\" , height: \"261px\"";
    private static final int MB_64 = 0x4000000;
    protected ScriptEngine scriptEngine;

    public VizJSDot() {
        try {
            InputStream vizJs = VizJSDot.class.getResourceAsStream("/viz.js");
            if (vizJs == null) {
                throw new IllegalArgumentException("viz.js not found");
            }
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            this.scriptEngine = scriptEngineManager.getEngineByName("nashorn");
            this.scriptEngine.eval(IOUtils.toString((InputStream)vizJs, (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("viz.js", e);
        }
    }

    public String identifier() {
        return "Viz.js 1.7.1 (Graphviz 2.40.1, Expat 2.1.0, Emscripten 1.37.9)";
    }

    public String format() {
        return "svg";
    }

    public String render(File dotFile, File diagramFile) {
        try {
            String dotSource = IOUtils.toString((URL)dotFile.toURI().toURL(), (Charset)StandardCharsets.UTF_8);
            String svg = this.toSvg(dotSource, 0x4000000);
            try (DefaultBufferedWriter diagramWriter = new DefaultBufferedWriter(diagramFile);){
                IOUtils.write((String)svg, (Writer)diagramWriter);
            }
            return "";
        }
        catch (Exception e) {
            throw new RenderException(e.getMessage());
        }
    }

    protected String toSvg(String dotSource, int jsEngineMemorySize) {
        try {
            this.scriptEngine.getBindings(100).put("dotSource", (Object)dotSource);
            return (String)this.scriptEngine.eval("Viz(dotSource,options = { totalMemory: " + jsEngineMemorySize + " , images: [{ path: \"../../images/foreignKeys.png\"" + ICON_SIZE + " },{ path: \"../../images/primaryKeys.png\"" + ICON_SIZE + " }]})");
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

