/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.xml.dom;

import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.model.TableIndex;
import org.schemaspy.output.xml.dom.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlIndexFormatter {
    public void appendIndexes(Node tableNode, Table table) {
        boolean showId = table.getId() != null;
        table.getIndexes().stream().sorted().forEachOrdered(i -> this.appendIndex(tableNode, i, showId));
    }

    public void appendIndex(Node tableNode, TableIndex tableIndex, boolean showId) {
        Document document = tableNode.getOwnerDocument();
        Element indexNode = document.createElement("index");
        if (showId) {
            DOMUtil.appendAttribute((Node)indexNode, (String)"id", (String)String.valueOf(tableIndex.getId()));
        }
        DOMUtil.appendAttribute((Node)indexNode, (String)"name", (String)tableIndex.getName());
        DOMUtil.appendAttribute((Node)indexNode, (String)"unique", (String)String.valueOf(tableIndex.isUnique()));
        for (TableColumn column : tableIndex.getColumns()) {
            Element columnNode = document.createElement("column");
            DOMUtil.appendAttribute((Node)columnNode, (String)"name", (String)column.getName());
            DOMUtil.appendAttribute((Node)columnNode, (String)"ascending", (String)String.valueOf(tableIndex.isAscending(column)));
            indexNode.appendChild(columnNode);
        }
        tableNode.appendChild(indexNode);
    }
}

