/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util;

import java.util.HashMap;
import java.util.Map;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.util.DataTableConfig;
import org.schemaspy.view.HtmlConfig;

public class DataTableConfig {
    private final Parameters databaseObjects;
    private final Parameters standardTable;
    private final Parameters indexesTable;
    private final Parameters checkTable;
    private Parameters routineTable;
    private Parameters fkTable;
    private Parameters columnTable;
    private Parameters anomalies;
    private Map<String, Object> pageScopeMap = new HashMap();

    public DataTableConfig(CommandLineArguments commandLineArguments) {
        this.databaseObjects = new Parameters(commandLineArguments.isNoDbObjectPaging(), commandLineArguments.getDbObjectPageLength(), commandLineArguments.isDbObjectLengthChange());
        this.pageScopeMap.put("databaseObjects", this.getParameterMap(this.databaseObjects, commandLineArguments.getHtmlConfig()));
        this.standardTable = new Parameters(commandLineArguments.isNoTablePaging(), commandLineArguments.getTablePageLength(), commandLineArguments.isTableLengthChange());
        this.pageScopeMap.put("standardTable", this.getParameterMap(this.standardTable, commandLineArguments.getHtmlConfig()));
        this.indexesTable = new Parameters(commandLineArguments.isNoIndexPaging(), commandLineArguments.getIndexPageLength(), commandLineArguments.isIndexLengthChange());
        this.pageScopeMap.put("indexesTable", this.getParameterMap(this.indexesTable, commandLineArguments.getHtmlConfig()));
        this.checkTable = new Parameters(commandLineArguments.isNoCheckPaging(), commandLineArguments.getCheckPageLength(), commandLineArguments.isCheckLengthChange());
        this.pageScopeMap.put("checkTable", this.getParameterMap(this.checkTable, commandLineArguments.getHtmlConfig()));
        this.routineTable = new Parameters(commandLineArguments.isNoRoutinePaging(), commandLineArguments.getRoutinePageLength(), commandLineArguments.isRoutineLengthChange());
        this.pageScopeMap.put("routineTable", this.getParameterMap(this.routineTable, commandLineArguments.getHtmlConfig()));
        this.fkTable = new Parameters(commandLineArguments.isNoFkPaging(), commandLineArguments.getFkPageLength(), commandLineArguments.isFkLengthChange());
        this.pageScopeMap.put("fkTable", this.getParameterMap(this.fkTable, commandLineArguments.getHtmlConfig()));
        this.columnTable = new Parameters(commandLineArguments.isNoColumnPaging(), commandLineArguments.getColumnPageLength(), commandLineArguments.isColumnLengthChange());
        this.pageScopeMap.put("columnTable", this.getParameterMap(this.columnTable, commandLineArguments.getHtmlConfig()));
        this.anomalies = new Parameters(commandLineArguments.isNoAnomaliesPaging(), commandLineArguments.getAnomaliesPageLength(), commandLineArguments.isAnomaliesLengthChange());
        this.pageScopeMap.put("anomalies", this.getParameterMap(this.anomalies, commandLineArguments.getHtmlConfig()));
    }

    public Map<String, Object> getParameterMap(Parameters parameters, HtmlConfig htmlConfig) {
        boolean isPaginationEnabled = htmlConfig.isPaginationEnabled();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("paging", isPaginationEnabled && !parameters.noPaging);
        parameterMap.put("pageLength", parameters.pageLength);
        parameterMap.put("lengthChange", parameters.lengthChange);
        return parameterMap;
    }

    public Map<String, Object> getPageScopeMap() {
        return this.pageScopeMap;
    }
}

