/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.TableColumn;
import org.schemaspy.util.Markdown;
import org.schemaspy.view.MustacheTableColumnRelatives;

public class MustacheTableColumn {
    private TableColumn column;
    private List<MustacheTableColumnRelatives> parents = new ArrayList();
    private List<MustacheTableColumnRelatives> children = new ArrayList();
    private boolean indexColumn;
    private String rootPath;

    public MustacheTableColumn(TableColumn tableColumn) {
        this.column = tableColumn;
        this.prepareRelatives(this.children, false);
        this.prepareRelatives(this.parents, true);
    }

    public MustacheTableColumn(TableColumn tableColumn, boolean indexColumn, String rootPath) {
        this(tableColumn);
        this.indexColumn = indexColumn;
        this.rootPath = rootPath;
    }

    public TableColumn getColumn() {
        return this.column;
    }

    public String getKey() {
        String keyType = "";
        if (this.column.isPrimary()) {
            keyType = " class='primaryKey' title='Primary Key'";
        } else if (this.column.isForeignKey()) {
            keyType = " class='foreignKey' title='Foreign Key'";
        } else if (this.indexColumn) {
            keyType = " class='" + this.markAsIndexColumn() + "' title='Indexed'";
        }
        return keyType;
    }

    public String getKeyTitle() {
        String keyTitle = "";
        if (this.column.isPrimary()) {
            keyTitle = "Primary Key";
        } else if (this.column.isForeignKey()) {
            keyTitle = "Foreign Key";
        } else if (this.indexColumn) {
            keyTitle = "Indexed";
        }
        return keyTitle;
    }

    public String getKeyClass() {
        String keyClass = "";
        if (this.column.isPrimary()) {
            keyClass = "primaryKey";
        } else if (this.column.isForeignKey()) {
            keyClass = "foreignKey";
        } else if (this.indexColumn) {
            keyClass = "indexedColumn";
        }
        return keyClass;
    }

    public String getKeyIcon() {
        String keyIcon = "";
        if (this.column.isPrimary() || this.column.isForeignKey()) {
            keyIcon = "<i class='icon ion-key iconkey' style='padding-left: 5px;'></i>";
        } else if (this.indexColumn) {
            keyIcon = "<i class='fa fa-sitemap fa-rotate-120' style='padding-right: 5px;'></i>";
        }
        return keyIcon;
    }

    public String getNullable() {
        return this.column.isNullable() ? "\u221a" : "";
    }

    public String getTitleNullable() {
        return this.column.isNullable() ? "nullable" : "";
    }

    public String getAutoUpdated() {
        return this.column.isAutoUpdated() ? "\u221a" : "";
    }

    public String getTitleAutoUpdated() {
        return this.column.isAutoUpdated() ? "Automatically updated by the database" : "";
    }

    private String markAsIndexColumn() {
        return this.indexColumn ? "indexedColumn" : "";
    }

    public String getDefaultValue() {
        return String.valueOf(this.column.getDefaultValue());
    }

    public List<MustacheTableColumnRelatives> getParents() {
        return this.parents;
    }

    public List<MustacheTableColumnRelatives> getChildren() {
        return this.children;
    }

    public String getComments() {
        String comments = this.column.getComments();
        comments = new Markdown(comments, this.rootPath).toHtml();
        return comments;
    }

    private void prepareRelatives(List<MustacheTableColumnRelatives> relatives, boolean dumpParents) {
        Set relativeColumns = dumpParents ? this.column.getParents() : this.column.getChildren();
        for (TableColumn relativeColumn : relativeColumns) {
            ForeignKeyConstraint constraint = dumpParents ? relativeColumn.getChildConstraint(this.column) : relativeColumn.getParentConstraint(this.column);
            MustacheTableColumnRelatives relative = new MustacheTableColumnRelatives(relativeColumn, constraint);
            relatives.add(relative);
        }
    }
}

